-- Item Types: (Right now the script only includes "Weapon" types. Other types can be manually added.
-- 	Clothing
-- 	Container
-- 	Drainable
-- 	Food
-- 	Key
-- 	KeyRing
-- 	Literature
-- 	Normal
-- 	Weapon
-- 	WeaponPart

-- Setup the default ModOptions for the mod
SimpleWeaponDurability = SimpleWeaponDurability or {}

SimpleWeaponDurability.ConditionLowerChanceMultiplier = 2
SimpleWeaponDurability.IncludeMelee = true
SimpleWeaponDurability.IncludeRanged = true


function MultiplyAllItemsConditionLowerChance()

	-- You can change this to increase the durability percentage. 2 = %200 durability (Twice as much durability).
	local iConditionLowerChanceMultiplier = SimpleWeaponDurability.ConditionLowerChanceMultiplier
	local oAllItems = ScriptManager.instance:getAllItems()

	for iItemsCount=0,(oAllItems:size() - 1) do
		MultiplyItemConditionLowerChance(oAllItems:get(iItemsCount), iConditionLowerChanceMultiplier)
	end

end

function MultiplyItemConditionLowerChance(oItem, iConditionLowerChanceMultiplier)

	-- Some simple flags to filter what items will be adjusted
	local bIncludeMelee = SimpleWeaponDurability.IncludeMelee
	local bIncludeRanged = SimpleWeaponDurability.IncludeRanged

	if oItem ~= nil then

		-- These variables are all the information you would need to include or exclude specific items, mods, etc. Ex: If you wanted to exclude a mod you would use sModuleName in the conditional statement on line 37.
		local sItemType = oItem:getTypeString()
		local sModuleName = oItem:getModuleName()
		local sItemName = oItem:getName()
		local bIsRanged = oItem:isRanged()

		local iItemCurrentConditionLowerChance = oItem:getConditionLowerChance()

		-- Additional logic can be added here. Anything NOT matching the criteria below is ignored and does not have its durability increased.
		if (iItemCurrentConditionLowerChance ~= nil) and (iItemCurrentConditionLowerChance ~= 1000000) and (sItemType == "Weapon") then
			
			-- Logical expressions to determine if item is included and should be adjusted or not
			if (bIsRanged == true and bIncludeRanged == true) or (bIsRanged ~= true and bIncludeMelee == true) then
				-- Uncomment the below line in order to see what items' durability is being updated in the logs. Logs are located at C:\Users\{username}\Zomboid\Logs on windows. Unsure on Linux or other OS.
				-- print("(Debug Simple Weapon Durability) Item Name: "..sModuleName.."."..sItemName)
				
				-- Uncomment the below lines in order to see the condition lower chances before and after values in the logs. Logs are located at C:\Users\{username}\Zomboid\Logs on windows. Unsure on Linux or other OS.
				-- print("(Debug Simple Weapon Durability) Original Lower Chance: "..tostring(iItemCurrentConditionLowerChance))
				-- print("(Debug Simple Weapon Durability) Modified Lower Chance: "..tostring(iItemCurrentConditionLowerChance * iConditionLowerChanceMultiplier))
				oItem:setConditionLowerChance(iItemCurrentConditionLowerChance * iConditionLowerChanceMultiplier)
			end
		end
	end

end

-- Thanks to NoctisFalco (https://steamcommunity.com/sharedfiles/filedetails/?id=2619072426) as their code was used as an example for setting up ModOptions
if ModOptions and ModOptions.getInstance then

    function SimpleWeaponDurabilityOnModOptionsApply(optionValues)
        SimpleWeaponDurability.ConditionLowerChanceMultiplier = optionValues.settings.options.ConditionLowerChanceMultiplier
        SimpleWeaponDurability.IncludeMelee = optionValues.settings.options.IncludeMelee
        SimpleWeaponDurability.IncludeRanged = optionValues.settings.options.IncludeRanged
    end
	
    function SimpleWeaponDurabilityOnModOptionsApplyInGame(optionValues)
        SimpleWeaponDurabilityOnModOptionsApply(optionValues)
    end	

    local SETTINGS = {
        options_data = {
            ConditionLowerChanceMultiplier = {
				"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "100",
                name = "IGUI_SimpleWeaponDurability_ConditionLowerChanceMultiplier",
                tooltip = "IGUI_SimpleWeaponDurability_ConditionLowerChanceMultiplier_ToolTip",
                default = 2,
                OnApplyMainMenu = SimpleWeaponDurabilityOnModOptionsApply,
                OnApplyInGame = SimpleWeaponDurabilityOnModOptionsApplyInGame,
            },
            IncludeMelee = {
                name = "IGUI_SimpleWeaponDurability_IncludeMelee",
                tooltip = "IGUI_SimpleWeaponDurability_IncludeMelee_ToolTip",
                default = true,
                OnApplyMainMenu = SimpleWeaponDurabilityOnModOptionsApply
            },
            IncludeRanged = {
                name = "IGUI_SimpleWeaponDurability_IncludeRanged",
                tooltip = "IGUI_SimpleWeaponDurability_IncludeRanged_ToolTip",
                default = true,
                OnApplyMainMenu = SimpleWeaponDurabilityOnModOptionsApply
            }
        },

        mod_id = 'SimpleWeaponDurability',
        mod_shortname = 'Simple Weapon Durability',
        mod_fullname = 'Simple Weapon Durability',
    }

    ModOptions:getInstance(SETTINGS)
    ModOptions:loadFile()
	
	Events.OnGameBoot.Add(function() SimpleWeaponDurabilityOnModOptionsApplyInGame({ settings = SETTINGS }) end);
	
end

Events.OnGameBoot.Add(MultiplyAllItemsConditionLowerChance)
